/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.network;

import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.LunarForecast;
import corgitaco.enhancedcelestials.network.S2CPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public class LunarForecastChangedPacket
implements S2CPacket {
    private final LunarForecast lunarForecast;

    public LunarForecastChangedPacket(LunarForecast lunarForecast) {
        this.lunarForecast = lunarForecast;
    }

    public static LunarForecastChangedPacket readFromPacket(FriendlyByteBuf buf) {
        try {
            return new LunarForecastChangedPacket((LunarForecast)buf.m_130057_(LunarForecast.CODEC));
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        try {
            buf.m_130059_(LunarForecast.CODEC, (Object)this.lunarForecast);
        }
        catch (Exception e) {
            throw new IllegalStateException("Lunar Forecast packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    @Override
    public void handle(Level level) {
        LunarContext lunarContext;
        if (level != null && (lunarContext = ((EnhancedCelestialsWorldData)level).getLunarContext()) != null) {
            lunarContext.getLunarForecast().getForecast().clear();
            lunarContext.getLunarForecast().getForecast().addAll(this.lunarForecast.getForecast());
            lunarContext.getLunarForecast().setLastCheckedGameTime(this.lunarForecast.getLastCheckedGameTime());
        }
    }
}

